//
//  SocketStreamClient.h
//  FullControl
//
//  Created by Francesco Burelli on 12/12/09.
//  Copyright 2009 Francesco Burelli. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <netinet/in.h>

@class SocketStreamClient;

@protocol SocketStreamClientDelegate <NSObject>
@optional
-(void)willConnectWithService:(NSNetService *)netService;
-(void)didConnectWithService:(NSNetService *)netService;
-(void)didNotConnectWithService:(NSNetService *)netService; // when disconnected
-(void)didReceiveData:(NSData *)theData from:(NSNetService *)netService;
-(void)didReceiveError:(NSError *)streamError;

@end

@interface SocketStreamClient : NSObject {
	id _delegate;
	NSNetService *_service;
	CFSocketRef socket;
	
	NSInputStream *_iStream;
	NSOutputStream *_oStream;
	
	BOOL input;
	BOOL output;
	BOOL _connected;
	
	NSMutableData *dataToSend;

}

@property(assign) id<SocketStreamClientDelegate> delegate;
@property(readonly) NSNetService *service;
@property(assign) NSInputStream *iStream;
@property(assign) NSOutputStream *oStream;
@property(readonly) BOOL connected;

-(id)init;
-(void)connectWithService:(NSNetService *)netService; // service must be just resolved !
-(void)disconnect;
-(NSInteger)sendData:(NSData *)theData;

@end
