//
//  MainViewController.m
//  SampleBrushes
//
//  Created by Andrea Busi on 01/03/10.
//  Copyright BubiDevs 2010. All rights reserved.
//

#import "MainViewController.h"
#import "MainView.h"


@implementation MainViewController


- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}

- (void)viewDidLoad {
    [super viewDidLoad];
	
	dimensionePennello = 5.0;
	colorePennello = [[UIColor colorWithRed:1.0 green:0.0 blue:0.0 alpha:1.0] retain];
}

- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
	
	UITouch *touch = [touches anyObject];
	ultimoPunto = [touch locationInView:viewDisegno];
}

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {

	UITouch *touch = [touches anyObject];	
	CGPoint puntoCorrente = [touch locationInView:viewDisegno];
	
	// definiamo il contest grafico
	UIGraphicsBeginImageContext(viewDisegno.frame.size);
	[viewDisegno.image drawInRect:CGRectMake(0, 0, viewDisegno.frame.size.width, viewDisegno.frame.size.height)];
	// settiamo la forma e la dimensione del pennello
	CGContextSetLineCap(UIGraphicsGetCurrentContext(), kCGLineCapRound);
	CGContextSetLineWidth(UIGraphicsGetCurrentContext(), dimensionePennello);
	// convertiamo il colore e impostiamolo come colore del pennello
	const CGFloat *components = CGColorGetComponents([colorePennello CGColor]);
	CGContextSetRGBStrokeColor(UIGraphicsGetCurrentContext(), components[0], components[1], components[2], components[3]);
	// disegna il percorso
	CGContextBeginPath(UIGraphicsGetCurrentContext());
	CGContextMoveToPoint(UIGraphicsGetCurrentContext(), ultimoPunto.x, ultimoPunto.y);
	CGContextAddLineToPoint(UIGraphicsGetCurrentContext(), puntoCorrente.x, puntoCorrente.y);
	CGContextStrokePath(UIGraphicsGetCurrentContext());
	// settiamo il disegno appena creato
	viewDisegno.image = UIGraphicsGetImageFromCurrentImageContext();
	UIGraphicsEndImageContext();
	
	ultimoPunto = puntoCorrente;	
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
	
	[self touchesMoved:touches withEvent:event];
}

- (IBAction)cancella{
	viewDisegno.image = nil;
}




/*
 // Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
 - (void)viewDidLoad {
 [super viewDidLoad];
 }
 */


/*
 // Override to allow orientations other than the default portrait orientation.
 - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
 // Return YES for supported orientations
 return (interfaceOrientation == UIInterfaceOrientationPortrait);
 }
 */


- (void)flipsideViewControllerDidFinish:(FlipsideViewController *)controller{
	
	[self dismissModalViewControllerAnimated:YES];
}


- (IBAction)showInfo {    
	
	FlipsideViewController *controller = [[FlipsideViewController alloc] initWithNibName:@"FlipsideView" bundle:nil];
	controller.delegate = self;
	controller.modalTransitionStyle = UIModalTransitionStyleFlipHorizontal;
	
	[self presentModalViewController:controller animated:YES];
	
	[controller release];
}



/*
 // Override to allow orientations other than the default portrait orientation.
 - (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
 // Return YES for supported orientations
 return (interfaceOrientation == UIInterfaceOrientationPortrait);
 }
 */

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end
