//
//  SampleTwitterClientViewController.m
//  SampleTwitterClient
//
//  Created by Andrea Busi on 28/12/09.
//  Copyright BubiDevs 2009. All rights reserved.
//

#import "SampleTwitterClientViewController.h"
#import "Tweet.h"

@implementation SampleTwitterClientViewController

@synthesize listaTweet, spinner;

-(void)viewDidLoad{
	
	// Qui vanno dichiarati username e password per accedere a Twitter
    NSString *username = @"user_name";
    NSString *password = @"password";
    
    // Create a TwitterEngine and set our login details.
    twitterEngine = [[MGTwitterEngine alloc] initWithDelegate:self];
    [twitterEngine setUsername:username password:password];
    
    // Get updates from people the authenticated user follows.
    [twitterEngine getFollowedTimelineFor:username since:nil startingAtPage:0];
	
	[spinner startAnimating];
}

- (void)requestSucceeded:(NSString *)requestIdentifier{
    NSLog(@"Request succeeded (%@)", requestIdentifier);
}


- (void)requestFailed:(NSString *)requestIdentifier withError:(NSError *)error{
    NSLog(@"Twitter request failed! (%@) Error: %@ (%@)", 
          requestIdentifier, 
          [error localizedDescription], 
          [[error userInfo] objectForKey:NSErrorFailingURLStringKey]);
	[spinner stopAnimating];
	UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Errore!" message:@"Connessione non riuscita.\nControlla i dati d'accesso" delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
	[alert show];
	[alert release];
}


- (void)directMessagesReceived:(NSArray *)messages forRequest:(NSString *)identifier{
    NSLog(@"Got direct messages:\r%@", messages);
}


- (void)userInfoReceived:(NSArray *)userInfo forRequest:(NSString *)identifier{
    NSLog(@"Got user info:\r%@", userInfo);
}


- (void)miscInfoReceived:(NSArray *)miscInfo forRequest:(NSString *)identifier{
	NSLog(@"Got misc info:\r%@", miscInfo);
}

- (void)statusesReceived:(NSArray *)statuses forRequest:(NSString *)identifier{
	
	listaTweet = [[NSMutableArray alloc] init];
	Tweet *elemento;
	
    for (int i=0; i<statuses.count ; i++) {
		elemento =  [[Tweet alloc] init];
		//NSLog("el: %@",[statuses objectAtIndex:i]);
		elemento.testo = [self getMessaggio:[statuses objectAtIndex:i]];
		elemento.user = [self getUser:[statuses objectAtIndex:i]];
		elemento.immagine = [[UIImage imageWithData:[NSData dataWithContentsOfURL:[self getUrlImage:[statuses objectAtIndex:i]]]]retain];
		[listaTweet addObject:elemento];
	}
	
	[elemento release];
	
	for (int j=0; j<[listaTweet count]; j++) {
		Tweet *elemento = [listaTweet objectAtIndex:j];
		NSLog(@"testo: %@, user: %@",elemento.testo,elemento.user);
	}
	
	[spinner stopAnimating];
}

-(NSString*)getMessaggio:(NSDictionary*)element{
	return [element objectForKey:@"text"];
}

-(NSString*)getUser:(NSDictionary*)element{
	return [[element objectForKey:@"user"] objectForKey:@"screen_name"];
}

-(NSURL*)getUrlImage:(NSDictionary*)element{
	NSString *url = [[element objectForKey:@"user"] objectForKey:@"profile_image_url"];
	return [NSURL URLWithString:url];
}




/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/


/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
