//
//  TrashAppViewController.m
//  TrashApp
//
//  Created by Andrea Busi on 19/03/10.
//  Copyright BubiDevs 2010. All rights reserved.
//

#import "TrashAppViewController.h"

@implementation TrashAppViewController

- (void)touchesMoved:(NSSet *)touches withEvent:(UIEvent *)event {
	UITouch *touch = [[event allTouches] anyObject];
	if ([touch view] == imageLogo) {
		imageLogo.center = [touch locationInView:self.view];
	}		
}

- (void)touchesEnded:(NSSet *)touches withEvent:(UIEvent *)event {
	if (CGRectContainsRect([imageCestino frame], [imageLogo frame])){
		imageCestino.image = [UIImage imageNamed:@"TrashIconFull.png"];
		[self cancella];
	}
}

- (void)cancella{
	cancellato = YES;
	[UIView beginAnimations:nil context:NULL];
	[UIView setAnimationDuration:0.5];
	imageLogo.transform = CGAffineTransformMakeScale(.001, .001);
	[UIView commitAnimations];
}

- (IBAction)ripristina {
	if (cancellato) {
		[UIView beginAnimations:nil context:NULL];
		[UIView setAnimationDuration:0.5];
		imageLogo.transform = CGAffineTransformIdentity;
		imageCestino.image = [UIImage imageNamed:@"TrashIconEmpty.png"];
		imageLogo.center = CGPointMake(155.0, 100.0);
		[UIView commitAnimations];
	}
}

/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/


/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
