//
//  guessTheColorViewController.m
//  guessTheColor
//
//  Created by ignazioc on 6/21/10.
//  Copyright home 2010. All rights reserved.
//

#import "guessTheColorViewController.h"

@implementation guessTheColorViewController
@synthesize sliderred,slidergreen,sliderblue,secretColorView;



- (void)showNextColor
{
	red = ((float)rand()/ RAND_MAX);
	green = ((float)rand()/ RAND_MAX);
	blue = ((float)rand()/ RAND_MAX);
	[secretColorView setBackgroundColor:[UIColor colorWithRed:red green:green blue:blue alpha:1]];
	[self performSelector:@selector(resetView) withObject:nil afterDelay:1.5];
}

- (IBAction)resetView
{
	[secretColorView setBackgroundColor:[UIColor colorWithRed:0.5 green:0.5 blue:0.5 alpha:1]];
}

- (IBAction)slideChanged:(id)sender
{
	[secretColorView setBackgroundColor:[UIColor colorWithRed:[sliderred value] green:[slidergreen value] blue:[sliderblue value] alpha:1]];
}

- (IBAction)guessColor:(id)sender
{
	
	float errorerosso = fabs(sliderred.value - red);
	float erroregreen = fabs(slidergreen.value - green);
	float erroreblue = fabs(sliderblue.value - blue);
	NSString *msg =[NSString stringWithFormat: @"ERRORE\nRED: %d%%\nGREEN: %d%%\nBLUE: %d%%",(int)(errorerosso * 100),
					(int)(erroregreen * 100),
					(int)(erroreblue * 100)];
	UIAlertView *alert  = [[UIAlertView alloc] initWithTitle:@"GUESS" message:msg delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
	[alert show];
	[alert release];
}

- (IBAction)imaloser:(id)sender
{
	[sliderred setValue:red animated:YES];
	[slidergreen setValue:green animated:YES];
	[sliderblue setValue:blue animated:YES];
	[secretColorView setBackgroundColor:[UIColor colorWithRed:red green:green blue:blue alpha:1]];
}


/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if ((self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil])) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/



// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	[self showNextColor];
}


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
