//
//  URLbuilder.m
//  devFlickr
//
//  Created by ignazioc00 on 6/1/10.
//  Copyright 2010 IgnazioC dev. All rights reserved.
//

#import "URLbuilder.h"


@implementation URLbuilder

- (void) setURLarray:(NSMutableArray *)anArray
{
	URLarray = anArray;
}

- (NSMutableArray *)getURLarray
{
	return URLarray;
}

- (void) setXMLdata:(NSData *)data
{
	XMLdata = data;
}

- (NSData *) getXMLdata
{
	return XMLdata;
}

- (id)initWithXMLdata:(NSData *)data
{
	if (self = [super init])
    {
		[self setXMLdata:data];
    }
    return self;	
}


- (NSMutableArray *) startParsing
{
	NSXMLParser *feedParser = [[NSXMLParser alloc] initWithData:[self getXMLdata]];
	[feedParser setDelegate:self];
	[feedParser parse];
	[feedParser release];
}




//INIZIA IL PROCESSO DI PARSING
- (void) parserDidStartDocument:(NSXMLParser *)parser
{
	[self setURLarray:[NSMutableArray arrayWithCapacity:100]];
}


//INIZIA IL RICONOSCIMENTO DI UN ELEMENTO
- (void) parser:(NSXMLParser *)parser 
didStartElement:(NSString *)elementName 
   namespaceURI:(NSString *)namespaceURI 
  qualifiedName:(NSString *)qName 
	 attributes:(NSDictionary *)attributeDict
{
	if ([elementName isEqualToString:@"photo"]) {
		[[self getURLarray] addObject:[NSMutableString stringWithFormat:@"http://farm%@.static.flickr.com/%@/%@_%@_m.jpg",
						  [attributeDict objectForKey:@"farm"],
						  [attributeDict objectForKey:@"server"],
						  [attributeDict objectForKey:@"id"],
						  [attributeDict objectForKey:@"secret"]]];
	}
}


- (void) parserDidEndDocument:(NSXMLParser *)parser
{
	if ([[self getURLarray] count] == 0) {
		NSLog(@"ERRORE");
	}
	//[self performSelectorOnMainThread:@selector(refreshFeedTerminated) withObject:nil waitUntilDone:NO];
}






@end
