//
//  devFlickrViewController.m
//  devFlickr
//
//  Created by ignazioc00 on 5/29/10.
//  Copyright __MyCompanyName__ 2010. All rights reserved.
//

#import "devFlickrViewController.h"
#import "interestingness.h"
#import "URLbuilder.h"

@implementation devFlickrViewController
@synthesize currentPhotoNum,imageView,act;

- (IBAction)refreshPhotoList
{
	[act startAnimating];
	[NSThread detachNewThreadSelector:@selector(getXML) toTarget:self withObject:nil];			
}



- (void)getXML
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	interestingness *inter = [[interestingness alloc] initWithApiKey:@"bd4890c606144764897cd145bd880d95"];
	[inter downloadXML];
	URLbuilder *urlBuilder = [[URLbuilder alloc] initWithXMLdata:[inter getinterestingnessXML]];
	[urlBuilder startParsing];
	urlArray = [[NSArray arrayWithArray:[urlBuilder getURLarray]] retain];
	
	[inter release];
	[urlBuilder release];
	
	[self performSelectorOnMainThread:@selector(getXMLterminated) withObject:nil waitUntilDone:NO];
	[pool drain];
	
}


- (void)getXMLterminated
{
	NSNumber *num = [NSNumber numberWithInt:0];
	[self viewPhotoAtIndex:num];
	[act stopAnimating];
}



- (IBAction)nextPhoto
{
	if (currentphoto + 1  < [urlArray count]) {
		[act startAnimating];
		NSNumber *num = [NSNumber numberWithInt:currentphoto + 1];
		[NSThread detachNewThreadSelector:@selector(viewPhotoAtIndex:) toTarget:self withObject:num];			
	}

}

- (IBAction)prevPhoto
{
	if (currentphoto - 1 >= 0 ) {
		[act startAnimating];
		NSNumber *num = [NSNumber numberWithInt:currentphoto + 1];
		[NSThread detachNewThreadSelector:@selector(viewPhotoAtIndex:) toTarget:self withObject:num];			
	}
}

- (IBAction)savePhoto {
	UIImage *img = [imageView image];
	UIImageWriteToSavedPhotosAlbum( img, self, @selector(image:didFinishSavingWithError:contextInfo:), nil );
}


- (void)image:(UIImage *)image didFinishSavingWithError:(NSError *)error contextInfo:(void *)contextInfo
{
	NSString *message;
	NSString *title;
	if (!error)
	{
		title = @"Ok";
		message = @"foto salvata";
		
	}
	else
	{
		title = @"Error";
		message = [error description];
		
	}
	UIAlertView *alert = [[UIAlertView alloc]
						  initWithTitle:title
						  message:message 
						  delegate:self
						  cancelButtonTitle:@"OK"
						  otherButtonTitles:nil];
	[alert show];
	[alert release];
	
}


- (IBAction)viewPhotoAtIndex:(NSNumber *)position
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];
	int k = [position intValue];
	NSURL *url = [NSURL URLWithString:	[urlArray objectAtIndex:k]];
	NSData *data = [NSData dataWithContentsOfURL:url];
	UIImage *img = [[UIImage alloc] initWithData:data];
	[imageView setImage:img];
	currentphoto = k;
	currentPhotoNum.text = [NSString stringWithFormat:@"Foto %d su %d",k+1,[urlArray count]];
	[img release];
	[self performSelectorOnMainThread:@selector(viewPhotoTerminated) withObject:nil waitUntilDone:NO];
	[pool drain];
}

- (void)viewPhotoTerminated
{
	[act stopAnimating];
	
}


// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	[self refreshPhotoList];
}



/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}

@end
