//
//  ControllaConnessioniViewController.m
//  ControllaConnessioni
//
//  Created by Andrea Busi on 16/02/10.
//  Copyright BubiDevs 2010. All rights reserved.
//

#import "ControllaConnessioniViewController.h"
#import "Reachability.h"

@implementation ControllaConnessioniViewController



/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/


/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

-(IBAction)eseguiControllo {
	internetReach = [[Reachability reachabilityForInternetConnection] retain];
	[self check:internetReach];

	wifiReach = [[Reachability reachabilityForLocalWiFi] retain];
	[self check:wifiReach];
}

-(void)check:(Reachability*) curReach{
	NetworkStatus netStatus = [curReach currentReachabilityStatus];

	switch (netStatus){
        case NotReachable:{
			label3g.text = @"No";
			labelWifi.text = @"No";
            break;
        }
		case ReachableViaWWAN:{
			label3g.text = @"Si";
            break;
        }
        case ReachableViaWiFi:{
			labelWifi.text = @"Si";
            break;
		}
    }
}

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
	[wifiReach release];
	[internetReach release];
	[label3g release];
	[labelWifi release];
}

@end
