//
//  AccessContactViewController.m
//  AccessContact
//
//  Created by Andrea Busi on 05/05/09.
//  Copyright BubiDevs 2009. All rights reserved.
//

#import "AccessContactViewController.h"

@implementation AccessContactViewController

-(IBAction)getContatto {
	//Crea il picker
	ABPeoplePickerNavigationController *picker = [[ABPeoplePickerNavigationController alloc] init];
	//Imposta il delegate del picker come vista principale
	picker.peoplePickerDelegate = self;
	//Visualizza il picker
	[self presentModalViewController:picker animated:YES];
	//Rilascio
	[picker release];
}

- (BOOL)peoplePickerNavigationController: (ABPeoplePickerNavigationController *)peoplePicker shouldContinueAfterSelectingPerson:(ABRecordRef)person {
	//Settiamo il nome
    labelNome.text = (NSString *)ABRecordCopyValue(person, kABPersonFirstNameProperty);
	//Settiamo il cognome
    labelCognome.text = (NSString *)ABRecordCopyValue(person, kABPersonLastNameProperty);	
	//Settiamo il numero di telefono
	ABMultiValueRef multi = ABRecordCopyValue(person, kABPersonPhoneProperty);
	labelTel.text = (NSString*)ABMultiValueCopyValueAtIndex(multi, 0);
	//Rimuove il controller "Contatti"
    [self dismissModalViewControllerAnimated:YES];	
    return NO;
}

- (void)peoplePickerNavigationControllerDidCancel:(ABPeoplePickerNavigationController *)peoplePicker {
    // facciamo tornare il controller alla vista principale
	[self dismissModalViewControllerAnimated:YES];
}

/*
// The designated initializer. Override to perform setup that is required before the view is loaded.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if (self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil]) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/


/*
// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
}
*/


/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/


- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning]; // Releases the view if it doesn't have a superview
    // Release anything that's not essential, such as cached data
}


- (void)dealloc {
    [super dealloc];
}

@end
