    //
//  MainViewController.m
//  AnimationExample
//
//  Created by Francesco Burelli on 23/10/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "MainViewController.h"

@implementation MainViewController

/*
 // The designated initializer.  Override if you create the controller programmatically and want to perform customization that is not appropriate for viewDidLoad.
- (id)initWithNibName:(NSString *)nibNameOrNil bundle:(NSBundle *)nibBundleOrNil {
    if ((self = [super initWithNibName:nibNameOrNil bundle:nibBundleOrNil])) {
        // Custom initialization
    }
    return self;
}
*/

/*
// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
}
*/

// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	
	toolbar = [[UIToolbar alloc] init];
	[toolbar setAutoresizingMask:UIViewAutoresizingFlexibleWidth | UIViewAutoresizingFlexibleTopMargin];
	image = [[UIImageView alloc] initWithImage:[UIImage imageNamed:@"FullControlHelper.png"]];
	
	[toolbar setFrame:CGRectMake(0, self.view.frame.size.height - 44, self.view.frame.size.width, 44)];
	[self.view addSubview:toolbar];
	
	[image setFrame:CGRectMake((self.view.frame.size.width-128)/2, (self.view.frame.size.height-128)/2, 128, 128)];
	[self.view addSubview:image];
	
	toolbarVisible = YES;
	imageVisible = YES;
}

/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
    // Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
    
    // Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
	[toolbar release];
	[image release];
    [super dealloc];
}


-(void)setToolbarVisible:(BOOL)flag {
	// animation block
	if (flag)
		[UIView beginAnimations:@"toolbarAnimationVisible" context:NULL];
	else
		[UIView beginAnimations:@"toolbarAnimationHide" context:NULL];
	[UIView setAnimationDuration:0.3];
	[UIView setAnimationDelegate:self];
	[UIView setAnimationDidStopSelector:@selector(animationDidStop:finished:context:)];
	
	// end of animation should have
	if (flag) {
		[toolbar setFrame:CGRectMake(0, self.view.frame.size.height - 44, self.view.frame.size.width, 44)];
	}
	else {
		// hide (move toolbar down)
		[toolbar setFrame:CGRectMake(0, self.view.frame.size.height, self.view.frame.size.width, 44)];
	}
	
	// end of animation's block
	[UIView commitAnimations];
	
}
-(void)setImageVisible:(BOOL)flag {
	// animation block
	if (flag)
		[UIView beginAnimations:@"imageAnimationVisible" context:NULL];
	else
		[UIView beginAnimations:@"imageAnimationHide" context:NULL];
	[UIView setAnimationDuration:0.3];
	[UIView setAnimationDelegate:self];
	[UIView setAnimationDidStopSelector:@selector(animationDidStop:finished:context:)];
	
	// end of animation should have
	if (flag) {
		[image setAlpha:1];
	}
	else {
		// hide (set transparent)
		[image setAlpha:0];
	}
	
	// end of animation's block
	[UIView commitAnimations];
}

-(void)startAnimation:(id)sender {
	[self setToolbarVisible:!toolbarVisible];
	[self setImageVisible:!imageVisible];
}

-(void)animationDidStop:(NSString *)animationID finished:(NSNumber *)finished context:(void *)context {
	if ([animationID isEqualToString:@"toolbarAnimationVisible"]) {
		toolbarVisible = YES;
	}
	else if ([animationID isEqualToString:@"imageAnimationVisible"]) {
		imageVisible = YES;
	}
	else if ([animationID isEqualToString:@"toolbarAnimationHide"]) {
		toolbarVisible = NO;
	}
	else if ([animationID isEqualToString:@"imageAnimationHide"]) {
		imageVisible = NO;
	}
}

-(void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
	[self startAnimation:self];
}

@end
