//
//  singleton.m
//  articolo4
//
//  Created by Mac Andrea on 18/10/10.
//  Copyright 2010 università di Trento. All rights reserved.
//

#import "singleton.h"


@implementation singleton
NSMutableArray *arrayCondiviso;
NSMutableDictionary *itemCondiviso;
NSMutableString * stringaCondivisa;



static singleton *sharedClass = nil;

// Con questo metodo imposto il valore dell'array condiviso
+ (void)impostaArray:(NSMutableArray *)valore{
	arrayCondiviso = valore;
}

// Con questo metodo, prelevo il valore dell'array condiviso da qualsiasi classe
+ (NSMutableArray *)ritornaArray{
	return arrayCondiviso;
}

+ (void)impostaItem:(NSMutableDictionary *)valore{
	
	itemCondiviso = valore;
}

+ (NSMutableDictionary *)ritornaItem{
	
	return itemCondiviso;
}

+ (void)impostaStringa:(NSMutableString *)valore{
	stringaCondivisa = valore;
}


+ (NSMutableString *)ritornaStringa{
	return stringaCondivisa;
}




+ (singleton *)sharedManager
{
    @synchronized(self) {
        if (sharedClass == nil) {
            [[self alloc] init]; // assignment not done here
        }
    }
    return sharedClass;
}

+ (id)allocWithZone:(NSZone *)zone
{
    @synchronized(self) {
        if (sharedClass == nil) {
            sharedClass = [super allocWithZone:zone];
            return sharedClass;  // assignment and return on first allocation
        }
    }
    return nil; //on subsequent allocation attempts return nil
}

- (id)copyWithZone:(NSZone *)zone
{
    return self;
}

- (id)retain
{
    return self;
}

- (unsigned)retainCount
{
    return UINT_MAX;  
}

- (void)release
{
    //do nothing
}

- (id)autorelease
{
    return self;
}

@end
