//
//  rotationViewController.m
//  rotation
//
//  Created by Giorgio Nobile on 19/10/10.
//  Copyright 2010 __MyCompanyName__. All rights reserved.
//

#import "rotationViewController.h"

@implementation rotationViewController

@synthesize locManager;
@synthesize imageRotation;
@synthesize courseValue;





// Implement viewDidLoad to do additional setup after loading the view, typically from a nib.
- (void)viewDidLoad {
    [super viewDidLoad];
	//istanzio LocationManager
	[imageRotation setImage:[UIImage imageNamed:@"arrow.png"]];
	self.locManager = [[CLLocationManager alloc] init];
	locManager.delegate = self;
	[locManager startUpdatingHeading];
	
}



/*
// Override to allow orientations other than the default portrait orientation.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Return YES for supported orientations
    return (interfaceOrientation == UIInterfaceOrientationPortrait);
}
*/

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	[locManager stopUpdatingHeading];
	self.locManager = nil;
	self.imageRotation = nil;

}


- (void)dealloc {
    [super dealloc];
	[locManager release];
	[imageRotation release];

}

#pragma mark -
#pragma mark locManager Methods

	 - (void)locationManager:(CLLocationManager *)manager didUpdateHeading:(CLHeading *)newHeading 
	{
		//acquisico il valore numerico indicante la mia "direzione"
		NSString *headValue = [[NSString alloc] initWithFormat:@"%3.0f", newHeading.trueHeading];
		//lo converto in intero
		int myIntHead = [headValue intValue];
		//lo faccio processare al metodo messo a disposizione da quartz facendo ruotare l'immagine
		//in base al radiante 
		[imageRotation setTransform:CGAffineTransformMakeRotation(myIntHead * 3.14159/180)];
		courseValue.text = headValue;
		[headValue release];	
	}
	 

@end
