//
//  UIView+Animation.m
//  CategoriesTutorial
//
//  Created by Costantino Pistagna on 12/19/10.
//  Copyright 2010-2011 Costantino Pistagna. All rights reserved.
//

#import "UIView+Animation.h"


@implementation UIView (animation) 

-(void) pushViewTo:(UIView *)aView {
	CGAffineTransform transform = CGAffineTransformMakeScale(0.1, 0.1);
	self.transform = transform;
	self.userInteractionEnabled = YES;
	[aView addSubview:self];
	self.center = CGPointMake(160, 240);
	[UIView beginAnimations:@"pushViewToScreen" context:nil];
	[UIView setAnimationCurve:UIViewAnimationCurveEaseInOut];
	[UIView setAnimationDuration:0.3];
	[UIView setAnimationDelegate:self];
	[UIView setAnimationDidStopSelector:@selector(pushViewToSecondPart)];
	CGAffineTransform transform2 = CGAffineTransformMakeScale(1.1, 1.1);
	self.transform = transform2;
	[UIView commitAnimations];
}

-(void) pushViewToSecondPart {
	[UIView beginAnimations:@"pushViewToScreen" context:nil];
	[UIView setAnimationCurve:UIViewAnimationCurveEaseInOut];
	[UIView setAnimationDuration:0.3];
	CGAffineTransform transform2 = CGAffineTransformMakeScale(1.0, 1.0);
	self.transform = transform2;
	[UIView commitAnimations];
}

-(void)removeFromView {
	[UIView beginAnimations:@"removeFromView" context:nil];
	[UIView setAnimationCurve:UIViewAnimationCurveEaseInOut];
	[UIView setAnimationDuration:0.3];
	[UIView setAnimationDelegate:self];
	[UIView setAnimationDidStopSelector:@selector(removeFromViewSecondPart)];
	CGAffineTransform transform2 = CGAffineTransformMakeScale(1.1, 1.1);
	self.transform = transform2;
	[UIView commitAnimations];
	
}

-(void)removeFromViewSecondPart {
	[UIView beginAnimations:@"removeFromViewSecondPart" context:nil];
	[UIView setAnimationCurve:UIViewAnimationCurveEaseInOut];
	[UIView setAnimationDuration:0.3];
	[UIView setAnimationDelegate:self];
	[UIView setAnimationDidStopSelector:@selector(removeFromViewThirdPart)];
	CGAffineTransform transform2 = CGAffineTransformMakeScale(0.1, 0.1);
	self.transform = transform2;
	[UIView commitAnimations];
}	

-(void)removeFromViewThirdPart {
	[self removeFromSuperview];
}

#pragma mark UITouch events
- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event {
    UITouch *touch = [touches anyObject];
    if (touch.view == self)
        [self removeFromView];
}

@end
