//
//  MainViewController.m
//  ClassEx
//
//  Created by valvoline on 11/29/10.
//  Copyright 2010 Universita  di Catania. All rights reserved.
//

#import "MainViewController.h"
#import <QuartzCore/QuartzCore.h>

@implementation MainViewController

-(id)initWithTitle:(NSString *)aTitle andImage:(NSString *)anImage andTag:(NSInteger)aTag {
	if(self = [super init]) {
		UITabBarItem *myItem = [[UITabBarItem alloc] initWithTitle:aTitle
															 image:[UIImage imageNamed:anImage] 
															   tag:aTag];
		myTag = aTag;
		self.tabBarItem = myItem;
		[myItem release];
	}
	return self;
}

-(id)init {
	if(self = [super init]) {
	}
	return self;
}

// Implement loadView to create a view hierarchy programmatically, without using a nib.
- (void)loadView {
	UIView *tmpView = [[UIView alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
	[tmpView setBackgroundColor:[UIColor redColor]];

	myLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, 320, 80)];
	[myLabel setText:@"Buon natale!"];
	[myLabel setFont:[UIFont systemFontOfSize:24]];
	[myLabel setTextAlignment:UITextAlignmentCenter];
	[myLabel setBackgroundColor:[UIColor clearColor]];
	[tmpView addSubview:myLabel];
	[myLabel release];
	
	myField = [[UITextField alloc] initWithFrame:CGRectMake(0, 220, 320, 80)];
	[myField setBackgroundColor:[UIColor yellowColor]];
	[tmpView addSubview:myField];
	[myField release];
	myField.delegate = self;
	
	
	UIButton *tmpButton = [UIButton buttonWithType:UIButtonTypeCustom];
	[tmpButton setImage:[UIImage imageNamed:@"SantaClaus.png"] forState:UIControlStateNormal];
	[tmpButton setFrame:CGRectMake(20, 100, 104, 131)];
	[tmpButton addTarget:self 
				  action:@selector(buttonPressed:) 
		forControlEvents:UIControlEventTouchUpInside];
	
	[tmpView addSubview:tmpButton];
	self.view = tmpView;
	[tmpView release];
}

-(void)buttonPressed:(id)sender {
		myLabel.text = @"il botton è stato premuto";
}


-(void)viewDidAppear:(BOOL)animated {
/*
	UIAlertView *alertView = [[UIAlertView alloc] initWithTitle:@"viewDidAppear"
														message:@"la view è apparsa" 
													   delegate:nil 
											  cancelButtonTitle:@"OK" 
											  otherButtonTitles:nil];
	[alertView show];
	[alertView release];
*/
}

-(void)viewDidDisappear:(BOOL)animated {
}


-(void)viewWillDisappear:(BOOL)animated {
}


#pragma mark UITextField delegate
- (BOOL)textFieldShouldBeginEditing:(UITextField *)textField {
	return YES;
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	[textField resignFirstResponder];
	myLabel.text = [NSString stringWithString:textField.text];
	//myLabel.text = textField.text;
	return YES;
}


- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	if(!(self.tabBarController.selectedIndex == myTag)) {
		NSLog(@"remove self.view");
		[self.view removeFromSuperview];
		self.view = nil;
	}
}

- (void)viewDidUnload {
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}


- (void)dealloc {
    [super dealloc];
}


@end
