//
//  TutorialTabBarAppDelegate.m
//  TutorialTabBar
//
//  Created by Pasquale Matrisciano on 11/02/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "TutorialTabBarAppDelegate.h"
#import "Tab1ViewController.h"
#import "Tab2ViewController.h"
#import "Tab3ViewController.h"

@implementation TutorialTabBarAppDelegate

@synthesize window,tabBarController;


#pragma mark -
#pragma mark Application lifecycle

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions {    
    
	// 'controllers' conterrà tutti gli elementi che comporranno la UITabBar
	// Consosco a priori la capacità dell'array e lo specifico ottimizzando le prestazioni
    NSMutableArray *controllers = [[NSMutableArray alloc] initWithCapacity:3];
	
	// Alloco ed inizializzo l'oggetto di tipo UITabBarController
	tabBarController = [[UITabBarController alloc] init];
    
	// -----------------------------------------
	
	// Alloco ed inizializzo il promo UIViewController: si noti come il Nib Name è impostato a nil
	Tab1ViewController *tab1Controller = [[Tab1ViewController alloc] initWithNibName:nil bundle:nil];
	tab1Controller.title = @"Tab 1";
	tab1Controller.testo = @"Testo di prova Tab 1";
	// Aggiungo il controller all'array 'controllers'
	[controllers addObject:tab1Controller];
	// Rilascio l'oggetto
	[tab1Controller release];
	
	// -----------------------------------------
	
	Tab2ViewController *tab2Controller = [[Tab2ViewController alloc] initWithStyle:UITableViewStylePlain];
	tab2Controller.title = @"Tab 2";
	[controllers addObject:tab2Controller];
	[tab2Controller release];
	
	// -----------------------------------------
	
	Tab3ViewController *tab3Controller = [[Tab3ViewController alloc] initWithStyle:UITableViewStylePlain];
	tab3Controller.title = @"Tab 3";
	
	// Alloco ed inizializzo con l'oggetto UITableViewController un nuovo oggetto, di tipo UINavigationController, il quale gestirà
	// la view associata al terzo pulsante della UITabBar
	UINavigationController *nav3Controller = [[UINavigationController alloc] initWithRootViewController:tab3Controller];
	[controllers addObject:nav3Controller];
	
	[nav3Controller release];
	[tab3Controller release];
	
	// -----------------------------------------
	
	// I viewControllers di UITabBarController saranno quelli contenuti nell'array 'controllers'
	tabBarController.viewControllers = controllers;
	[controllers release];
	
	[window addSubview:tabBarController.view];
    [self.window makeKeyAndVisible];
    
    return YES;
}


- (void)applicationWillResignActive:(UIApplication *)application {
    
}


- (void)applicationDidEnterBackground:(UIApplication *)application {
    
}


- (void)applicationWillEnterForeground:(UIApplication *)application {
	
}


- (void)applicationDidBecomeActive:(UIApplication *)application {
    
}


- (void)applicationWillTerminate:(UIApplication *)application {
    
}


#pragma mark -
#pragma mark Memory management

- (void)applicationDidReceiveMemoryWarning:(UIApplication *)application {
    
}


- (void)dealloc {
	[tabBarController release];
    [window release];
    [super dealloc];
}


@end
