//
//  Brain.m
//  ButtonEnabler
//
//  Created by Francesco Guida on 11/03/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "Brain.h"


@implementation Brain

@synthesize operand;
@synthesize operationDictionary;

- (NSMutableDictionary *)operationDictionary {
	if (!operationDictionary) {
		operationDictionary = [[NSMutableDictionary alloc] init];
	}
	return operationDictionary;
}

- (void)addUnaryOperation:(NSString *)op whichExecutesBlock:(unary_operation_t)opBlock {
	[self.operationDictionary setObject:opBlock forKey:op];
}

- (double)performOperation:(NSString *)operation {
	unary_operation_t unaryOp = [self.operationDictionary objectForKey:operation];
	if (unaryOp) {
		self.operand = unaryOp(self.operand);
	}
	return self.operand;
}

@end
