//
//  UnaryCalculatorViewController.m
//  UnaryCalculator
//
//  Created by Francesco Guida on 11/03/11.
//  Copyright 2011 __MyCompanyName__. All rights reserved.
//

#import "UnaryCalculatorViewController.h"


@interface UnaryCalculatorViewController()
@property (nonatomic, readonly) Brain *brain;
@end

@implementation UnaryCalculatorViewController

@synthesize numField, resultLabel, operationControl;
@synthesize brain;

- (Brain  *)brain {
	// Allochiamo brain se ancora non è stato fatto
	if (!brain) {
		brain = [[Brain alloc] init];
	}
	return brain;
}

- (void)viewDidLoad {
    [super viewDidLoad];
	
	// Aggiungiamo al dizionario di operazioni del nostro brain 
	// le operazioni definite come blocchi
	
	unary_operation_t square = ^(double operand){
		return operand * operand;
	};
	[self.brain addUnaryOperation:@"sq" whichExecutesBlock:square];
	
	unary_operation_t sqroot = ^(double operand) {
		return sqrt(operand);
	};
	[self.brain addUnaryOperation:@"sqrt" whichExecutesBlock:sqroot];
	
	unary_operation_t sine = ^(double operand) {
		return sin(operand);
	};
	[self.brain addUnaryOperation:@"sin" whichExecutesBlock:sine];
	
	NumericKeyPadView *keyPad = [[NumericKeyPadView alloc] initWithFrame:CGRectMake(0, 0, 320, 210)];
	keyPad.delegate = self;
	
	self.numField.delegate = self;
	self.numField.inputView = keyPad;
}

- (void)userPressedButtonWithTitle:(NSString *)title {
	
	if (title) {
		if ([@"C" isEqualToString:title]) {
			self.numField.text = @"";
		} else if ([@"BS" isEqualToString:title]) {
			self.numField.text = [self.numField.text substringToIndex:self.numField.text.length - 1];
		} else if ([@"Calc" isEqualToString:title]) {
			[self textFieldShouldReturn:self.numField];
		} else if ([@"" isEqualToString:self.numField.text] && 
				   [@"." isEqualToString:title]) {
			self.numField.text = @"0.";
		} else {
			self.numField.text = [self.numField.text stringByAppendingString:title];
		}
	}
}

- (void)executeOp {
	
	double num = [self.numField.text doubleValue];
	
	if (num) {
		self.brain.operand = num;
	}
	
	NSString *operation;
	switch (self.operationControl.selectedSegmentIndex) {
		case SQ:
			operation = @"sq";
			break;
		case SQRT:
			operation = @"sqrt";
			break;
		case SIN:
			operation = @"sin";
			break;
	}
	
	double result = [self.brain performOperation:operation];
	self.resultLabel.text = [NSString stringWithFormat:@"%g", result];
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
	if (textField.text.length) {
		[textField resignFirstResponder];
		[self executeOp];
		return YES;
	} else {
		return NO;
	};
}

- (void)didReceiveMemoryWarning {
	// Releases the view if it doesn't have a superview.
    [super didReceiveMemoryWarning];
	
	// Release any cached data, images, etc that aren't in use.
}

- (void)viewDidUnload {
	// Release any retained subviews of the main view.
	// e.g. self.myOutlet = nil;
	self.numField = nil;
	self.resultLabel = nil;
	self.operationControl = nil;
}


- (void)dealloc {
	[brain release];
	[numFiled release];
	[resultLabel release];
	[operationControl release];
	
    [super dealloc];
}

@end