    //
//  MainViewController.m
//  iADTestApp
//
//  Created by Costantino Pistagna <valvoline@gmail.com> on 3/9/11.
//  Copyright 2011 iPhoneSmartApps.org All rights reserved.
//

#import "MainViewController.h"

typedef enum iADShowerSwitch { 
	showiADBanner = 0,
	hideiADBanner = 1
} iADShowerSwitch;

@implementation MainViewController

-(id)init {
	if(self = [super init]) {
		//make your own init, here.
	}
	return self;
}

- (void)renderTimerToScreen {
	[timerLabel setText:[NSString stringWithFormat:@"seconds elapsed: %d", myTimerCounter]];
}

- (void)incrementTimer {
	myTimerCounter++;
	[self renderTimerToScreen];
}

- (void)restartTimer {
	myScheduler = [NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(incrementTimer) userInfo:nil repeats:YES];
}

- (void)pauseTimer {
 	[myScheduler invalidate];
}

- (void)loadView {
	contentView = [[UIView alloc] initWithFrame:[[UIScreen mainScreen] applicationFrame]];
	[contentView setBackgroundColor:[UIColor redColor]];
	
	timerLabel = [[UILabel alloc] initWithFrame:CGRectMake(0, 140, 320, 20)];
	[timerLabel setBackgroundColor:[UIColor clearColor]];
	[timerLabel setFont:[UIFont systemFontOfSize:18]];
	[timerLabel setTextAlignment:UITextAlignmentCenter];
	[timerLabel setTextColor:[UIColor blackColor]];
	
	[contentView addSubview:timerLabel];
	[timerLabel release];
	
	myScheduler = [NSTimer scheduledTimerWithTimeInterval:1.0 target:self selector:@selector(incrementTimer) userInfo:nil repeats:YES];
	
	self.view = contentView;
	[contentView release];
}

- (void)viewWillAppear:(BOOL)animated {
	myTimerCounter = 0;
}

- (void)viewDidAppear:(BOOL)animated {
	_adBannerView = [self createAdBannerView];
	[contentView addSubview:_adBannerView];
}


#pragma mark ADBannerView related methods
- (ADBannerView *)createAdBannerView {
//	ADBannerView *myBannerView = [[[ADBannerView alloc] initWithFrame:CGRectZero] autorelease];
	ADBannerView *myBannerView = [[ADBannerView alloc] initWithFrame:CGRectZero];
	[myBannerView setRequiredContentSizeIdentifiers:[NSSet setWithObjects: ADBannerContentSizeIdentifierPortrait, nil]];
	[myBannerView setCurrentContentSizeIdentifier:ADBannerContentSizeIdentifierPortrait];            
	[myBannerView setDelegate:self];
	[myBannerView setAlpha:0.0];
	[myBannerView setCenter:CGPointMake(160, 500)];
	return [myBannerView autorelease];    
}

- (void)showHideAdView:(int)operationType {
    if (_adBannerView != nil) {        
		[_adBannerView setCurrentContentSizeIdentifier:ADBannerContentSizeIdentifierPortrait];
		
		[UIView beginAnimations:@"showHideAdView" context:nil];
		switch (operationType) {
			case hideiADBanner:
				[_adBannerView setCenter:CGPointMake(160, 500)];
				[_adBannerView setAlpha:0.0];
				break;
			case showiADBanner:
				[_adBannerView setCenter:CGPointMake(160, 460-25)];
				[_adBannerView setAlpha:1.0];
			default:
				break;
		}
        [UIView commitAnimations];
    }   
}

#pragma mark ADBannerViewDelegate
- (void)bannerViewDidLoadAd:(ADBannerView *)banner {
	[self showHideAdView:showiADBanner];
}

- (void)bannerView:(ADBannerView *)banner didFailToReceiveAdWithError:(NSError *)error {
	NSLog(@"ADBannerView ERROR: %@", [error localizedDescription]);
	[self showHideAdView:hideiADBanner];
}

- (BOOL)bannerViewActionShouldBegin:(ADBannerView *)banner willLeaveApplication:(BOOL)willLeave {
	[self pauseTimer];
	return YES;	
}

- (void)bannerViewActionDidFinish:(ADBannerView *)banner {
	[self restartTimer];
}

- (void)didReceiveMemoryWarning {
     [super didReceiveMemoryWarning];
     // Release any cached data, images, etc. that aren't in use.
}

- (void)viewDidUnload {
    [super viewDidUnload];
}

- (void)dealloc {
    [super dealloc];
}
@end
