//
//  MVC1AppDelegate.m
//  MVC1
//
//  Created by valvoline on 10/21/09.
//  Copyright __MyCompanyName__ 2009. All rights reserved.
//

#import "MVC1AppDelegate.h"

@implementation MVC1AppDelegate

- (void)applicationDidFinishLaunching:(UIApplication *)application {    
	
	//init della window principale
	window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] applicationFrame]];
	
	//init della view principale
	myView = [[UIView alloc] initWithFrame:window.frame];
	
	//spostiamo il centro 20 pixel piu' in alto per riempire tutto lo schermo
	myView.center = CGPointMake(myView.center.x, myView.center.y - 20);
	
	[myView setBackgroundColor:[UIColor grayColor]];
	
	//allochiamo e posizioniamo la statusBar
	statusBar = [[UILabel alloc] initWithFrame:CGRectMake(0, 400, 320, 80)];
	[statusBar setBackgroundColor:[UIColor orangeColor]];
	[statusBar setAlpha:0.7];
	[myView addSubview:statusBar];
	[statusBar release];

	[statusBar setTextAlignment:UITextAlignmentCenter];
	[statusBar setText:@"status bar"];
	
	
	button1 = [UIButton buttonWithType:UIButtonTypeRoundedRect];
	[button1 setFrame:CGRectMake(60, 180, 80, 30)];
	[button1 setTitle:@"left" forState:UIControlStateNormal];
	[button1 addTarget:self action:@selector(leftPressed) forControlEvents:UIControlEventTouchUpInside];

	button2 = [UIButton buttonWithType:UIButtonTypeRoundedRect];
	[button2 setFrame:CGRectMake(190, 180, 80, 30)];
	[button2 setTitle:@"right" forState:UIControlStateNormal];
	[button2 addTarget:self action:@selector(rightPressed) forControlEvents:UIControlEventTouchUpInside];
	
	//i bottoni non vanno rilasciati. non usano un metodo di allocazione diretto!
	[myView addSubview:button1];
	[myView addSubview:button2];
	
	mySlider = [[UISlider alloc] initWithFrame:CGRectMake(100, 60, 140, 150)];
	mySlider.maximumValue = 100;
	mySlider.minimumValue = 0;
	[mySlider addTarget:self action:@selector(sliderAction) forControlEvents:UIControlEventValueChanged];
	[myView addSubview:mySlider];
	[mySlider release];
	
	NSMutableArray *myItems= [[NSMutableArray alloc] init];
	[myItems addObject:[NSString stringWithString:@"Segment 1"]];
	[myItems addObject:[NSString stringWithString:@"Segment 2"]];
	mySegmentedControl = [[UISegmentedControl alloc] initWithItems:myItems];
	mySegmentedControl.segmentedControlStyle = UISegmentedControlStyleBar;
	[mySegmentedControl setFrame:CGRectMake(80, 20, 160, 50)];
	[myItems release];
	[mySegmentedControl addTarget:self action:@selector(segmentedAction) forControlEvents:UIControlEventValueChanged];

	//se vogliamo un valore gia' selezionato
	mySegmentedControl.selectedSegmentIndex = 0;
	[myView addSubview:mySegmentedControl];
	[mySegmentedControl release];
		
	//aggiungiamo la view principale alla window principale
	[window addSubview:myView];
	
	//e visualizziamo il risultato a schermo
    [window makeKeyAndVisible];
}


- (void)leftPressed {
	statusBar.text = [NSString stringWithString:@"left button pressed"];
}

- (void)rightPressed {
	statusBar.text = [NSString stringWithString:@"right button pressed"];
}

- (void)sliderAction {
	statusBar.text = [NSString stringWithFormat:@"slider changed to: %.2f", mySlider.value]; 
}

- (void)segmentedAction {
	statusBar.text = [NSString stringWithFormat:@"segmented control changed to: %d", mySegmentedControl.selectedSegmentIndex];

	//se vogliamo il nome
	statusBar.text = [NSString stringWithFormat:@"segmented control changed: %@", [mySegmentedControl titleForSegmentAtIndex:mySegmentedControl.selectedSegmentIndex]];
}

- (void)dealloc {
	
	//il dispose della window, rilascia anche tutti gli oggetti associati
    [window release];
    [super dealloc];
}

@end
