// inclusione moduli necessari
var redis = require('redis');
var request=require('request');

// definizione di un client Redis
var client = redis.createClient();

// gestione degli errori in Redis
client.on('error', function (err) {
    console.log("Errore: Redis ha risposto "+err);
});

function nomeAzione(s)
{
    // eliminiamo tutti gli apici dalla stringa
    return s.replace(/"/g,'');
}

function creaIndirizzo(codice)
{
    // inseriamo il codice del titolo azionario nell'indirizzo
    return 'http://download.finance.yahoo.com/d/quotes.csv?s='+codice+'&f=sl1d1t1c1ohgv&e=.csv';
}

function scaricaDati(codice)
{
  // scaricamento dati dal sito
  request(creaIndirizzo(codice), 
      function (error, response, body) {
    if (!error && response.statusCode == 200) {
        // codice di risposta HTTP 200: tutto ok!

        // costruiamo array con le parti della stringa separate da virgola
        ar=body.split(',');

        if (ar.length>1)
        {
          /* se l'array ha almeno due elementi assumiamo che il primo sia il nome del titolo 
            ed il secondo il suo valore: si possono effettuare ulteriori controlli sul formato */
          nome=nomeAzione(ar[0]);
          valore=ar[1];

          // inseriamo in Redis la coppia nome titolo/valore
          // N.B.: applichiamo il prefisso "stock:" per riconoscere queste chiavi nel db
          client.set("stock:"+nome,valore, redis.print);

        }  
    }
  });
}

/* codici relativi ai titoli di nostro interesse:
   Telecom Italia, Intesa San Paolo, ENI, Enel, Mediaset */
var daScaricare=['TIT.MI','ISP.MI','ENI.MI','ENEL.MI','MS.MI'];

// avvio del ciclo: scarichiamo i dati
daScaricare.forEach(function(v,i,a)
{
    scaricaDati(v);
});