package it.devapp.downloadmanagerexample;

import android.app.DownloadManager;
import android.net.Uri;
import android.os.Bundle;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.View;

public class MainActivity extends AppCompatActivity {

    private Uri uri;
    private DownloadManager.Request request;
    private DownloadManager manager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // recuperiamo un riferimento al servizio
        manager= (DownloadManager) getSystemService(DOWNLOAD_SERVICE);

        // definiamo l'URI da cui scaricare il file
        uri=Uri.parse("http://orientdb.com/docs/2.1/OrientDB-Manual.pdf");

        // Prepariamo la richiesta
        request=new DownloadManager.Request(uri);

        // titolo e descrizione che appariranno nella notifica
        request.setTitle("Manuale di OrientDB");
        request.setDescription("File PDF");

        // al termine dello scaricamento la notifica non scomparirà
        request.setNotificationVisibility(DownloadManager.Request.VISIBILITY_VISIBLE_NOTIFY_COMPLETED);

        Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
        setSupportActionBar(toolbar);

        FloatingActionButton fab = (FloatingActionButton) findViewById(R.id.fab);
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

            // riferimento univoco al download
            final long download_id=manager.enqueue(request);

            Snackbar.make(view, "Download avviato...", Snackbar.LENGTH_LONG)
                    .setAction("Annulla", new View.OnClickListener() {
                        @Override
                        public void onClick(View view) {

                            // cliccando sull'Action otteniamo la cancellazione del download
                            manager.remove(download_id);
                        }
                    }).show();
            }
        });
    }

}
