package it.devapp.esempioandroidfragment.fragments;


import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import java.text.SimpleDateFormat;
import java.util.Date;

import it.devapp.esempioandroidfragment.ElencoCitta;
import it.devapp.esempioandroidfragment.R;

public class CittaFragment extends Fragment {

    public static final String CITTAFRAGMENT_TAG="CITTAFRAGMENT_TAG";

    private static final String ARG_ID_IMG = "img";
    private static final String ARG_NOME_CITTA = "nome";
    private static final String ARG_DESCR_CITTA = "descr";

    private String nomeCitta;
    private String descrizioneCitta;
    private int idImg;


    public static CittaFragment newInstance(ElencoCitta.Citta citta) {
        CittaFragment fragment = new CittaFragment();
        Bundle args = new Bundle();
        args.putInt(ARG_ID_IMG, citta.immagine);
        args.putString(ARG_NOME_CITTA, citta.nome);
        args.putString(ARG_DESCR_CITTA, citta.presentazione);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (getArguments() != null) {
            idImg = getArguments().getInt(ARG_ID_IMG);
            nomeCitta = getArguments().getString(ARG_NOME_CITTA);
            descrizioneCitta = getArguments().getString(ARG_DESCR_CITTA);
        }
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View v=inflater.inflate(R.layout.fragment_citta, container, false);

        ImageView imageView= (ImageView) v.findViewById(R.id.imageView);
        TextView txt_nome= (TextView) v.findViewById(R.id.citta);
        TextView txt_descr= (TextView) v.findViewById(R.id.descrizione);

        imageView.setImageResource(idImg);
        txt_nome.setText(nomeCitta);
        txt_descr.setText(descrizioneCitta);
        return v;
    }

}
